/****************************************************************************
* Donohue and Wolfers (2006) 
* Figure 9
* Reporting Bias in Estimated Effects of Executions on Homicide: 
* Preferred Estimates across Six Studies
****************************************************************************/


clear
set more off
cd "..."
use "Estimates.dta", clear

set seed 1
reg beta se if national==0 & study~="Zb"
reg beta se if main==1 & national==0 & study~="Zb"
bys study: reg beta se if national==0 & study~="Zb"

correl beta se if national==0 & study~="Zb"
correl beta se if main==1 & national==0 & study~="Zb"
bys study: correl beta se if national==0 & study~="Zb"

gen effect=beta if main==1
tomode effect, by(study) replace
gen ci95upper=effect+1.96*se
gen ci95lower=effect-1.96*se

gen str20 studyname=""
for X in any DRS DS KLS MG S Za \ Y in any "Dezbakhsh, Rubin & Shepherd" "Dezbakhsh & Shepherd" "Katz, Levitt & Shustorovich" "Mocan & Gittings" "Shepherd" "Zimmerman": replace studyname="Y" if study=="X"


#delimit;
twoway 
	(line t2 se, lcolor(black) lpattern(dash) sort) 
	(scatter beta se if study=="DRS", msymbol(circle) mcolor(red) mlabel(studyname) mlabcolor(black) mlabposition(12))
	(scatter beta se if study=="DS" & national==0, jitter(2) msymbol(square) mcolor(blue) mlabel(studyname) mlabcolor(black) mlabposition(12))
	(scatter beta se if study=="KLS", jitter(1) msymbol(X) mcolor(chocolate) mlabel(studyname) mlabcolor(black) mlabposition(3))
	(scatter beta se if study=="MG", msymbol(triangle_hollow) mcolor(magenta) mlabel(studyname) mlabcolor(black) mlabposition(12))
	(scatter beta se if study=="S", jitter(2) msymbol(triangle) mcolor(green) mlabel(studyname) mlabcolor(black) mlabposition(12)) 
	(scatter beta se if study=="Za", jitter(1) msymbol(square_hollow) mcolor(black) mlabel(studyname) mlabcolor(black) mlabposition(9)) 
	if national==0 & main==1
,
	ytitle("Coefficient estimate:" "Number of homicides reduced per execution", size(medsmall))
	xtitle("Standard error of estimated effect")
	ylabel(, angle(horizontal))  
	title(Reporting Bias: Estimated Effects of Executions on Homicide) 
	subtitle("H0: No reporting bias implies that estimated effects should be unrelated to the standard error" "H1: Results are more likely to be reported if the effect is at least twice the standard error (t>2)", size(small)) 
	note(
		"Coefficients converted into homicides reduced for the average executing state in 1996." 
		"The central estimate from each study is shown."
	, size(small))
	text(10.5 4.2 "Estimates above dashed line" "are statistically significant" "at p=.05", size(small) justification(center))
	legend(off)
	xsize(10) ysize(7.5)
;


